//--------------------------------------------------------------
//
//		BoxEaterHook.c
//
//		Author:	Christian Schubert 
//		Email:	christian@cschubert.net
//		Last changed: 2003-01-20
//
//--------------------------------------------------------------

//-------- Includes -----------
#include "stdafx.h"
#include "BoxEaterHook.h"
#include "BoxEaterLog.h"
#include "cbtype.h"
#include "centura.h"

#define BUTTONBUFSIZE 50

extern "C" LONG CBEXPAPI SalCurrentLineNumber (VOID);

BOOL bChildWindowExpected = FALSE;
BOOL bInhibit = FALSE;
int nWndInfoCount = 0;
int nCurrentWndInfo = -1;
WNDINFOARR* pWndInfoBase = NULL;
CString sCurrentCaption;
CString sCurrentMessage;
HHOOK	hHook;

// Find a specific entry
int FindWndInfo ( CString sMessage, CString sCaption, BOOL bExact )
{
	int nCount;

	for ( nCount = 0; nCount < nWndInfoCount; nCount++ )
	{
		if ( !bExact )
		{
			if ( !strncmp ( sCaption, *((*pWndInfoBase)[nCount].sCaption), strlen ( *((*pWndInfoBase)[nCount].sCaption) ) ) &&
				!strncmp ( sMessage, *((*pWndInfoBase)[nCount].sMessage), strlen ( *((*pWndInfoBase)[nCount].sMessage) ) ) )
				return nCount;
		}
		else
		{
			if ( !strcmp ( sCaption, *((*pWndInfoBase)[nCount].sCaption) ) &&
				!strcmp ( sMessage, *((*pWndInfoBase)[nCount].sMessage) ) )
				return nCount;
		}
	}

	// nothing found
	return -1;

}

// Loop through the children of the message box
BOOL CALLBACK EnumCallback ( HWND hwnd, LPARAM lParam )
{
	char sBuffer[1024], sBuffer2[1024], sAction[10];
	int nActionFound = 0;
	long nLineNumber;
	static int nButtonCount;

	GetClassName ( hwnd, sBuffer, 1024 );

	if ( lParam == 1 )
	{
		// Is this the message box text?
		if ( !strcmp ( sBuffer, "Static" ) )
		{
			SendMessage ( hwnd, WM_GETTEXT, sizeof ( sBuffer2 ), (LPARAM)sBuffer2 );
			if ( strlen ( sBuffer2 ) != 0 )
			{
				sCurrentMessage = sBuffer2;
				nCurrentWndInfo = FindWndInfo ( sBuffer2, sCurrentCaption, FALSE );
				if ( nCurrentWndInfo > -1 )
				{
					nButtonCount = 0;
					return FALSE;
				}
			}
		}
	}

	if ( lParam == 2 )
	{
		if ( !strcmp ( sBuffer, "Button" ) && nCurrentWndInfo != -1 )
		{
			nButtonCount++;

			if ( nButtonCount == 1 && (*pWndInfoBase)[nCurrentWndInfo].nAction == ACTION_BUTTON1 ||
				 nButtonCount == 2 && (*pWndInfoBase)[nCurrentWndInfo].nAction == ACTION_BUTTON2 ||
				 nButtonCount == 3 && (*pWndInfoBase)[nCurrentWndInfo].nAction == ACTION_BUTTON3 ||
				 (*pWndInfoBase)[nCurrentWndInfo].nAction == ACTION_LOGONLY )
			{
				// make sure, no other message boxes are captured
				bInhibit = TRUE;

				nLineNumber = SalCurrentLineNumber ( );

				switch ( nButtonCount )
				{
					case 1: strcpy ( sAction, "Button 1" ); break;
					case 2: strcpy ( sAction, "Button 2" ); break;
					case 3: strcpy ( sAction, "Button 3" ); break;
					default: strcpy ( sAction, "none" ); break;
				}

				// write logfile
				if ( (*pWndInfoBase)[nCurrentWndInfo].sLogFile )
					DoFileLog ( sCurrentMessage, sCurrentCaption, sAction, 
					(LPCTSTR)*((*pWndInfoBase)[nCurrentWndInfo].sLogFile), nLineNumber );

				// send message
				if ( (*pWndInfoBase)[nCurrentWndInfo].hWndMsg != NULL )
					DoPostMessage ( (*pWndInfoBase)[nCurrentWndInfo].hWndMsg, 
					(*pWndInfoBase)[nCurrentWndInfo].nMsg, sCurrentMessage, sCurrentCaption, 
					(*pWndInfoBase)[nCurrentWndInfo].nUserData, nLineNumber );

				// call callback function
				if ( (*pWndInfoBase)[nCurrentWndInfo].sCallbFunc->IsEmpty() == FALSE )
					DoCallback ( *((*pWndInfoBase)[nCurrentWndInfo].sCallbFunc), sCurrentMessage, sCurrentCaption, 
					(*pWndInfoBase)[nCurrentWndInfo].nUserData, nLineNumber );

				// write to event log
				if ( (*pWndInfoBase)[nCurrentWndInfo].sAppName->IsEmpty() == FALSE )
					DoEventLog ( sCurrentMessage, sCurrentCaption, sAction, 
					(LPCTSTR)*((*pWndInfoBase)[nCurrentWndInfo].sAppName), nLineNumber );

				if ( (*pWndInfoBase)[nCurrentWndInfo].nAction != ACTION_LOGONLY )
				{
					PostMessage ( hwnd, WM_LBUTTONDOWN, 0, 0 );
					PostMessage ( hwnd, WM_LBUTTONUP, 0, 0 );
				}

				bInhibit = FALSE;

				return FALSE;
			}

		}
	}

	return TRUE;
}

// CBT hook procedure
LRESULT CALLBACK HookProc ( int nCode, WPARAM wParam, LPARAM lParam )
{
	char sBuffer[MAXBUFSIZE];
	static int nStatus = 0;

	if ( nCode < 0 )
		return CallNextHookEx ( hHook, nCode, wParam, lParam );

	if ( nCode == HCBT_ACTIVATE && !bInhibit )
	{
		// lParam contains pointer to a CBT_CREATEWND struct
		GetClassName ( (HWND) wParam, sBuffer, sizeof ( sBuffer ) );
		if ( !strcmp ( sBuffer, "#32770" ) )
		{
			bChildWindowExpected = TRUE;

			SendMessage ( (HWND) wParam, WM_GETTEXT, sizeof ( sBuffer ), (LPARAM)sBuffer );
			sCurrentCaption = sBuffer;

			EnumChildWindows ( (HWND) wParam, EnumCallback, 1 );
			if ( nCurrentWndInfo != -1 )
				EnumChildWindows ( (HWND) wParam, EnumCallback, 2 );
		}
		else
		{
			bChildWindowExpected = TRUE;
			nCurrentWndInfo = -1;
		}

	}

	// allow activation of window
	return CallNextHookEx ( hHook, nCode, wParam, lParam );
}

