//--------------------------------------------------------------
//
//		BoxEaterLog.cpp
//
//		Author:	Christian Schubert 
//		Email:	christian@cschubert.net
//		Last changed: 2003-01-20
//
//--------------------------------------------------------------

//-------- Includes -----------
#include "stdafx.h"
#include "cbtype.h"
#include "centura.h"
#include "BoxEaterLog.h"

extern HINSTANCE	hGlobalModule;

typedef struct myBOXINFO
{
	LPCSTR		sMessage;
	LPCSTR		sTitle;
	long		nUserData;
	long		nLineNumber;
} BOXINFO;

// Log to file
BOOL DoFileLog ( LPCSTR sMsg, LPCSTR sCaption, LPCSTR sAction, LPCSTR sLogFile, long nLineNumber )
{
	HANDLE hFile;
	ULONG nBytesWritten, nError;
	CTime curTime = CTime::GetCurrentTime ( );
	CString sMessage = "";

	hFile = CreateFile ( sLogFile, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if ( !hFile )
	{
		nError = GetLastError ();
		return FALSE;
	}

	SetFilePointer ( hFile, 0, 0, FILE_END );

	sMessage.Format ( "%s\tLine: %u, Caption: \"%s\", Message: \"%s\", Action: %s\r\n", curTime.Format("%c"), nLineNumber, sCaption, sMsg, sAction );

	if ( !WriteFile ( hFile, sMessage, strlen ( sMessage ), &nBytesWritten, NULL ) )
	{
		nError = GetLastError ();
		CloseHandle ( hFile );
		return FALSE;
	}

	CloseHandle ( hFile );
	return TRUE;
}

// Call SqlWindows function
BOOL DoCallback ( LPCSTR sCallbFunc, LPCSTR sMessage, LPCSTR sTitle, LPARAM nUserData, long nLineNumber )
{
	int nError, nErrorPos;

	// Dummy result vars
	NUMBER nResult;
	HSTRING sResult;
	DATETIME dResult;
	HWND hResult;
	long nLength;
	HSTRING sCurrentContext;
	LPSTR pContext;
	char sCurrentContextValue[100];
	CString sHelp;

	sCurrentContext = SalContextCurrent();
	pContext = SWinHStringLock ( sCurrentContext, &nLength );
	memset ( sCurrentContextValue, '\0', sizeof ( sCurrentContextValue ) );
	memcpy ( sCurrentContextValue, pContext, min(nLength, 100) );

	sHelp.Format ( "%s ( '%s', '%s', %u, %u )", sCallbFunc, sMessage, sTitle, nUserData, nLineNumber );

	SalCompileAndEvaluate( sHelp.GetBuffer ( sHelp.GetLength () + 1 ), &nError, &nErrorPos, &nResult, &sResult, &dResult, &hResult, FALSE, sCurrentContextValue);

	SWinHStringUnlock ( sCurrentContext );
	return TRUE;

}

// Post a message to a specified window
BOOL DoPostMessage ( HWND hWndMsg, UINT nMsg, LPCTSTR sMessage, LPCTSTR sTitle, long nUserData, long nLineNumber )
{
	BOXINFO boxinfo;

	boxinfo.sMessage = sMessage;
	boxinfo.sTitle = sTitle;
	boxinfo.nUserData = nUserData;
	boxinfo.nLineNumber = nLineNumber;

	SendMessage ( hWndMsg, nMsg, 0, (LPARAM)&boxinfo );

	return TRUE;
}

// Log to system event log
BOOL DoEventLog ( LPCSTR sMsg, LPCSTR sCaption, LPCSTR sAction, LPCSTR sAppName, long nLineNumber )
{
	OSVERSIONINFO ovi;
	CString sMessage = "";
	CString sKey = "SYSTEM\\ControlSet001\\Services\\Eventlog\\Application";
	HANDLE hEventLog;
	LPCSTR pMsg;
	HKEY hKey1, hKey2;
	DWORD nResult;
	char sModuleFileName[256];
	long nType = 7;

	ovi.dwOSVersionInfoSize = sizeof ( ovi );
	if ( !GetVersionEx ( &ovi ) )
		return FALSE;

	// this is for NT only
	if ( ovi.dwPlatformId == VER_PLATFORM_WIN32_NT )
	{
		// logging an event in the system event log needs a specific key
		// open application key (or create it)
		if ( ERROR_SUCCESS == RegOpenKeyEx ( HKEY_LOCAL_MACHINE, sKey, 0, KEY_ALL_ACCESS, &hKey1 ) )
		{
			if ( ERROR_SUCCESS != RegOpenKeyEx ( hKey1, sAppName, 0, KEY_ALL_ACCESS, &hKey2 ) )
			{
				RegCreateKeyEx ( hKey1, sAppName, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey2, &nResult );
			}
			RegCloseKey ( hKey1 );
		}
		// set type value and the resource file containing the message resource (boxeater.dll)
		if ( hKey2 )
		{
			RegSetValueEx ( hKey2, "TypesSupported", 0, REG_DWORD, (BYTE*)&nType, sizeof ( nType ) );

			// get the name of the current DLL
			GetModuleFileName ( hGlobalModule, (LPSTR)sModuleFileName, sizeof ( sModuleFileName ) );
			RegSetValueEx ( hKey2, "EventMessageFile", 0, REG_SZ, (BYTE*)sModuleFileName, strlen ( sModuleFileName ) + 1 );

			RegCloseKey ( hKey2 );
		}

		// register our app
		hEventLog = RegisterEventSource ( NULL, sAppName );
		if ( !hEventLog )
			return FALSE;

		// format our string...
		sMessage.Format ( "Line: %u\r\n\r\nCaption: \"%s\"\r\n\r\nMessage: \"%s\"\r\n\r\nAction: %s\r\n", nLineNumber, sCaption, sMsg, sAction );
		pMsg = LPCSTR ( sMessage );

		// ...and write it
		if ( !ReportEvent ( hEventLog, EVENTLOG_ERROR_TYPE, 0, 1, NULL, 1, 0, &pMsg, NULL ) )
		{
			DeregisterEventSource ( hEventLog );
			return FALSE;
		}
		
		// clean up
		DeregisterEventSource ( hEventLog );

	}
	return TRUE;
}

