//--------------------------------------------------------------
//
//		BoxEaterMain.cpp
//
//		Author:	Christian Schubert 
//		Email:	christian@cschubert.net
//		Last changed: 2003-01-20
//
//--------------------------------------------------------------

//-------- Includes -----------
#include "stdafx.h"
#include "BoxEaterHook.h"
#include "BoxEaterMain.h"

extern BOOL bInhibit;
extern int nWndInfoCount;
extern WNDINFOARR* pWndInfoBase;
extern HHOOK hHook;

HANDLE hProcessHeap;
HINSTANCE	hGlobalModule;
int nRefCount = 0;

// Insert/Update a box info entry
BOOL BoxEater_AddBoxData ( LPSTR sMessage, LPSTR sCaption, int nAction, LPSTR sLogFile, HWND hWndMsg, UINT nMsg, 
				 LPSTR sCallbFunc, long nUserData, LPSTR sAppName )
{
	int nWndInfoFound = FindWndInfo ( sMessage, sCaption, TRUE );


	if ( nWndInfoCount == 0 )
		// allocate new mem
		pWndInfoBase = (WNDINFOARR*) HeapAlloc ( hProcessHeap, HEAP_ZERO_MEMORY, sizeof ( WNDINFO ) * (nWndInfoCount + 1) );
	else
		if ( nWndInfoFound == -1 )
			// resize existing mem if this is a new entry
			pWndInfoBase = (WNDINFOARR*) HeapReAlloc ( hProcessHeap, HEAP_ZERO_MEMORY, (LPVOID)pWndInfoBase, sizeof ( WNDINFO ) * (nWndInfoCount + 1) );

	if ( pWndInfoBase )
	{
		if ( nWndInfoFound == -1 )
		{
			nWndInfoFound = nWndInfoCount++;
			(*pWndInfoBase)[nWndInfoFound].sCaption = new CString;
			(*pWndInfoBase)[nWndInfoFound].sMessage = new CString;
			(*pWndInfoBase)[nWndInfoFound].sLogFile = new CString;
			(*pWndInfoBase)[nWndInfoFound].sCallbFunc = new CString;
			(*pWndInfoBase)[nWndInfoFound].sAppName = new CString;
		}

		*((*pWndInfoBase)[nWndInfoFound].sCaption) = sCaption;
		*((*pWndInfoBase)[nWndInfoFound].sMessage) = sMessage;
		(*pWndInfoBase)[nWndInfoFound].nAction = nAction;
		(*pWndInfoBase)[nWndInfoFound].hWndMsg = hWndMsg;
		*((*pWndInfoBase)[nWndInfoFound].sLogFile) = sLogFile;
		*((*pWndInfoBase)[nWndInfoFound].sCallbFunc) = sCallbFunc;
		(*pWndInfoBase)[nWndInfoFound].nUserData = nUserData;	
		(*pWndInfoBase)[nWndInfoFound].nMsg = nMsg;	
		*((*pWndInfoBase)[nWndInfoFound].sAppName) = sAppName;
	}
	else
		return FALSE;

	return TRUE;
}

// clear all box info entries
BOOL BoxEater_ClearBoxData ( )
{
	int nCount;

	for ( nCount = 0; nCount < nWndInfoCount; nCount++ )
	{
		delete (*pWndInfoBase)[nCount].sCaption;
		delete (*pWndInfoBase)[nCount].sMessage;
		delete (*pWndInfoBase)[nCount].sLogFile;
		delete (*pWndInfoBase)[nCount].sCallbFunc;
		delete (*pWndInfoBase)[nCount].sAppName;
	}

	if ( HeapFree ( hProcessHeap, 0, pWndInfoBase ) )
	{
		nWndInfoCount = 0;
		return TRUE;
	}

	return FALSE;
}

// clear CBT hook
BOOL BoxEater_ClearPopupHook ( )
{
	if ( hHook )
	{
		if ( --nRefCount <= 0 )
		{
			if ( !UnhookWindowsHookEx ( hHook ) )
				return FALSE;

			hHook = NULL;
		}
	}
	return TRUE;
}

// set CBT hook
BOOL BoxEater_SetPopupHook ( )
{
	if ( hHook )
	{	
		// if hook is already enabled just increase use counter 
		nRefCount++;
		return TRUE;
	}

	hHook = SetWindowsHookEx ( WH_CBT, (HOOKPROC)HookProc, hGlobalModule, GetCurrentThreadId() );

	if ( hHook )
	{
		nRefCount++;
		return TRUE;
	}
	else
		return FALSE;

}

                   
/////////////////////////////////////////////////////////////////////////////
// CNotifyApp


/////////////////////////////////////////////////////////////////////////////
// CNotifyApp construction

CBoxEater::CBoxEater()
{

	hGlobalModule = CBoxEater::m_hInstance;
	hProcessHeap = HeapCreate ( 0, 0, 0 );
}

CBoxEater::~CBoxEater()
{
	BoxEater_ClearBoxData ( );
	if ( hProcessHeap )
	{
		HeapDestroy ( hProcessHeap );
		hProcessHeap = 0;
	}
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CNotifyApp object

CBoxEater BoxEater;

BOOL CBoxEater::InitInstance() 
{
	if ( CWinApp::InitInstance() )
	{
		hGlobalModule = CBoxEater::m_hInstance;
		return TRUE;
	}
	return FALSE;
}

int CBoxEater::ExitInstance() 
{
	return CWinApp::ExitInstance();
}

