.head 0 +  Application Description: Centura SQLWindows/32 
"Ice Tea Foundation Classes"

Module:		Memory handling

Version:	1.0
Author:		Joe Meyer, Ice Tea Group, LLC.
.head 1 -  Outline Version - 4.0.35
.head 1 +  Design-time Settings
.data VIEWINFO
0000: 6F00000001000000 FFFF01000D004347 5458566965775374 6174650400010000
0020: 0000000000870000 002C000000020000 0003000000FFFFFF FFFFFFFFFFFCFFFF
0040: FFE2FFFFFFFFFFFF FF000000007C0200 004D010000010000 0000000000010000
0060: 000F4170706C6963 6174696F6E497465 6D00000000
.enddata
.head 2 -  Outline Window State: Normal
.head 2 +  Outline Window Location and Size
.data VIEWINFO
0000: 6600040003002D00 0000000000000000 0000B71E5D0E0500 1D00FFFF4D61696E
0020: 0000000000000000 0000000000000000 0000003B00010000 00000000000000E9
0040: 1E800A00008600FF FF496E7465726E61 6C2046756E637469 6F6E730000000000
0060: 0000000000000000 0000000000003200 0100000000000000 0000E91E800A0000
0080: DF00FFFF56617269 61626C6573000000 0000000000000000 0000000000000000
00A0: 3000010000000000 00000000F51E100D 0000F400FFFF436C 6173736573000000
00C0: 0000000000000000 0000000000000000
.enddata
.data VIEWSIZE
0000: D000
.enddata
.head 3 -  Left: -0.013"
.head 3 -  Top: 0.0"
.head 3 -  Width:  8.013"
.head 3 -  Height: 4.969"
.head 2 +  Options Box Location
.data VIEWINFO
0000: D4180909B80B1A00
.enddata
.data VIEWSIZE
0000: 0800
.enddata
.head 3 -  Visible? Yes
.head 3 -  Left: 4.15"
.head 3 -  Top: 1.885"
.head 3 -  Width:  3.8"
.head 3 -  Height: 2.073"
.head 2 +  Class Editor Location
.head 3 -  Visible? No
.head 3 -  Left: 0.575"
.head 3 -  Top: 0.094"
.head 3 -  Width:  5.063"
.head 3 -  Height: 2.719"
.head 2 +  Tool Palette Location
.head 3 -  Visible? No
.head 3 -  Left: 6.388"
.head 3 -  Top: 0.729"
.head 2 -  Fully Qualified External References? Yes
.head 2 -  Reject Multiple Window Instances? No
.head 2 -  Enable Runtime Checks Of External References? Yes
.head 2 -  Use Release 4.0 Scope Rules? No
.head 2 -  Edit Fields Read Only On Disable? No
.head 1 +  Libraries
.head 2 -  File Include: ITFCBase.apl
.head 1 +  Global Declarations
.head 2 +  Window Defaults
.head 3 +  Tool Bar
.head 4 -  Display Style? Etched
.head 4 -  Font Name: MS Sans Serif
.head 4 -  Font Size: 8
.head 4 -  Font Enhancement: System Default
.head 4 -  Text Color: System Default
.head 4 -  Background Color: System Default
.head 3 +  Form Window
.head 4 -  Display Style? Etched
.head 4 -  Font Name: MS Sans Serif
.head 4 -  Font Size: 8
.head 4 -  Font Enhancement: System Default
.head 4 -  Text Color: System Default
.head 4 -  Background Color: System Default
.head 3 +  Dialog Box
.head 4 -  Display Style? Etched
.head 4 -  Font Name: MS Sans Serif
.head 4 -  Font Size: 8
.head 4 -  Font Enhancement: System Default
.head 4 -  Text Color: System Default
.head 4 -  Background Color: System Default
.head 3 +  Top Level Table Window
.head 4 -  Font Name: MS Sans Serif
.head 4 -  Font Size: 8
.head 4 -  Font Enhancement: System Default
.head 4 -  Text Color: System Default
.head 4 -  Background Color: System Default
.head 3 +  Data Field
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Multiline Field
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Spin Field
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Background Text
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Pushbutton
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 3 +  Radio Button
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Check Box
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Option Button
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 3 +  Group Box
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Child Table Window
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  List Box
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Combo Box
.head 4 -  Font Name: Use Parent
.head 4 -  Font Size: Use Parent
.head 4 -  Font Enhancement: Use Parent
.head 4 -  Text Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 3 +  Line
.head 4 -  Line Color: Use Parent
.head 3 +  Frame
.head 4 -  Border Color: Use Parent
.head 4 -  Background Color: 3D Face Color
.head 3 +  Picture
.head 4 -  Border Color: Use Parent
.head 4 -  Background Color: Use Parent
.head 2 -  Formats
.head 2 +  External Functions
.head 3 -  ! 
*** ITFCMem.apl

.head 3 +  Library name: STRCI42.dll
.head 4 -  ThreadSafe: No
.head 4 +  Function: __CStructGetByte
.head 5 -  Description: Extract a byte from a buffer.
nResult = CStructGetByte( strBuffer, nOffset )
.head 5 -  Export Ordinal: 1
.head 5 +  Returns
.head 6 -  Number: BYTE
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetWord
.head 5 -  Description: Extract a word from a buffer.
nResult = CStructGetWord( strBuffer, nOffset )
.head 5 -  Export Ordinal: 3
.head 5 +  Returns
.head 6 -  Number: WORD
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetLong
.head 5 -  Description: Extract a long from a buffer.
nResult = CStructGetLong( strBuffer, nOffset )
.head 5 -  Export Ordinal: 5
.head 5 +  Returns
.head 6 -  Number: LONG
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetFloat
.head 5 -  Description: Extract a float from a buffer.
nResult = CStructGetFloat( strBuffer, nOffset )
.head 5 -  Export Ordinal: 7
.head 5 +  Returns
.head 6 -  Number: FLOAT
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetDouble
.head 5 -  Description: Extract a double from a buffer.
nResult = CStructGetDouble( strBuffer, nOffset )
.head 5 -  Export Ordinal: 9
.head 5 +  Returns
.head 6 -  Number: DOUBLE
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetBFloat
.head 5 -  Description: Extract a BFloat from a buffer and convert to double.
nResult = CStructGetBFloat( strBuffer, nOffset )
.head 5 -  Export Ordinal: 21
.head 5 +  Returns
.head 6 -  Number: DOUBLE
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 4 +  Function: __CStructGetString
.head 5 -  Description: Extract a string from a buffer.
nLength = CStructGetString( strBuffer, nOffset, nMaxWidth, strExtract )
.head 5 -  Export Ordinal: 11
.head 5 +  Returns
.head 6 -  Number: LONG
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: LONG
.head 6 -  Receive String: LPSTR
.head 4 +  Function: __CStructPutByte
.head 5 -  Description: Insert a byte into a buffer.
bOK = CStructPutByte( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 2
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: BYTE
.head 4 +  Function: __CStructPutWord
.head 5 -  Description: Insert a word into a buffer.
bOK = CStructPutWord( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 4
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: WORD
.head 4 +  Function: __CStructPutLong
.head 5 -  Description: Insert a long into a buffer.
bOK = CStructPutLong( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 6
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: LONG
.head 4 +  Function: __CStructPutFloat
.head 5 -  Description: Insert a byte into a buffer.
bOK = CStructPutFloat( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 8
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: FLOAT
.head 4 +  Function: __CStructPutDouble
.head 5 -  Description: Insert a double into a buffer.
bOK = CStructPutDouble( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 10
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: DOUBLE
.head 4 +  Function: __CStructPutBFloat
.head 5 -  Description: Convert double to BFloat and insert it into a buffer.
bOK = CStructPutBFloat( strBuffer, nOffset, nInsert )
.head 5 -  Export Ordinal: 22
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: DOUBLE
.head 4 +  Function: __CStructPutString
.head 5 -  Description: Insert a string into a buffer.
bOK = CStructPutString( strBuffer, nOffset, nMaxWidth, strInsert )
.head 5 -  Export Ordinal: 12
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: LONG
.head 6 -  String: LPSTR
.head 4 +  Function: __CStructCopyBuffer
.head 5 -  Description: Copy data from one String to another.
bOK = CStructCopyBuffer( strDest, nDestOffset, 
                         strSrc, nSrcOffset, nCopyLen ) 
.head 5 -  Export Ordinal: 19
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: DWORD
.head 6 -  Number: LONG
.head 6 -  Number: LONG
.head 4 +  Function: __CStructAllocFarMem
.head 5 -  Description: Allocate memory and return a far pointer.
nFarPointer = CStructAllocFarMem( nBytes )
.head 5 -  Export Ordinal: 13
.head 5 +  Returns
.head 6 -  Number: ULONG
.head 5 +  Parameters
.head 6 -  Number: LONG
.head 4 +  Function: __CStructFreeFarMem
.head 5 -  Description: Free memory allocated by CStructAllocFarMem.
bOK = CStructFreeFarMem( nFarPointer )
.head 5 -  Export Ordinal: 14
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: LONG
.head 4 +  Function: __CStructCopyToFarMem
.head 5 -  Description: Copy data from far memory to a String.
bOK = CStructCopyToFarMem( nFarPointer, strData, nDataLen  )
.head 5 -  Export Ordinal: 15
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: LONG
.head 6 -  String: LPVOID
.head 6 -  Number: LONG
.head 4 +  Function: __CStructCopyFromFarMem
.head 5 -  Description: Copy from a String to far memory.
bOK = CStructCopyFromFarMem( nFarPointer, strData, nMaxLen )
.head 5 -  Export Ordinal: 16
.head 5 +  Returns
.head 6 -  Boolean: BOOL
.head 5 +  Parameters
.head 6 -  Number: LONG
.head 6 -  Receive String: LPVOID
.head 6 -  Number: LONG
.head 3 +  Library name: CDLLI42.dll
.head 4 -  ThreadSafe: No
.head 4 +  Function: SWinStringGetBuffer
.head 5 -  Description:
.head 5 -  Export Ordinal: 0
.head 5 +  Returns
.head 6 -  Number: DWORD
.head 5 +  Parameters
.head 6 -  String: HSTRING
.head 6 -  Receive Number: LPLONG
.head 3 +  Library name: MSVCRT40.dll
.head 4 -  ThreadSafe: No
.head 4 +  Function: memset
.head 5 -  Description: Call memset( p_pPointer, p_nCharacter, p_nSize )
.head 5 -  Export Ordinal: 0
.head 5 -  Returns
.head 5 +  Parameters
.head 6 -  Number: LPVOID
.head 6 -  Number: INT
.head 6 -  Number: DWORD
.head 2 +  Constants
.data CCDATA
0000: 3000000000000000 0000000000000000 00000000
.enddata
.data CCSIZE
0000: 1400
.enddata
.head 3 +  System
.head 4 -  ! 
*** ITFCMem.apl

.head 4 -  ! // Errors
.head 4 +  Number: ITE_InvalidBufferPos			= -5
.head 5 -  ! CITFCMemory: the position from where to read/write is not valid
or would lead to memory access past the end of the buffer.
.head 4 +  Number: ITE_CStructError			= -6
.head 5 -  ! CITFCMemory: An error occured calling the CStruct dll
.head 4 +  Number: ITE_NoAllocatedMemory			= -7
.head 5 -  ! CITFCMemory: An error occured calling the CStruct dll
.head 4 -  ! // Number types
.head 4 -  Number: ITC_TYPE_BYTE				= 0x0101
.head 4 -  Number: ITC_TYPE_WORD				= 0x0202
.head 4 -  Number: ITC_TYPE_SHORT				= 0x0202
.head 4 -  Number: ITC_TYPE_LONG				= 0x0304
.head 4 -  Number: ITC_TYPE_INT				= 0x0304
.head 4 -  Number: ITC_TYPE_FLOAT				= 0x0404
.head 4 -  Number: ITC_TYPE_DOUBLE				= 0x0508
.head 4 -  Number: ITC_TYPE_BFLOAT				= 0x0608
.head 3 -  User
.head 3 -  Enumerations
.head 2 -  Resources
.head 2 -  Variables
.head 2 +  Internal Functions
.head 3 +  Function: ITFCMemCStrCreate
.head 4 -  Description:
.head 4 +  Returns
.head 5 +  Number:
.head 6 -  ! pointer to C-style string
.head 4 +  Parameters
.head 5 +  String: p_sValue
.head 6 -  ! the string to be converted to C-style
.head 4 -  Static Variables
.head 4 +  Local variables
.head 5 -  Number: pCStr
.head 5 -  Number: nLen
.head 4 +  Actions
.head 5 -  Set nLen = SalStrLength( p_sValue )
.head 5 +  If nLen
.head 6 -  Set pCStr = __CStructAllocFarMem( nLen + 1 )
.head 6 -  Call __CStructPutByte( pCStr, nLen, 0 )
.head 6 -  Call __CStructCopyToFarMem( pCStr, p_sValue, nLen )
.head 5 -  Return pCStr
.head 3 +  Function: ITFCMemCStrFree
.head 4 -  Description:
.head 4 -  Returns
.head 4 +  Parameters
.head 5 -  Receive Number: r_pCStr
.head 4 -  Static Variables
.head 4 -  Local variables
.head 4 +  Actions
.head 5 +  If r_pCStr
.head 6 -  Call __CStructFreeFarMem( r_pCStr )
.head 6 -  Set r_pCStr = 0
.head 2 -  Named Menus
.head 2 +  Class Definitions
.data RESOURCE 0 0 1 3852316556
0000: 6C0000004C000000 0000000000000000 0200000100FFFF01 00160000436C6173
0020: 73566172004F7574 6C696E6552006567 496E666F1A003C00 0009430049544643
0040: 4261736500380000 00020000000F010D 0000FE00FF930D00 0001FB00FF0F
.enddata
.head 3 -  ! 
*** ITFCMem.apl

.head 3 +  Functional Class: CITFCMemory
.head 4 -  Description: Wrapper around the CStruct buffer handling
.head 4 +  Derived From
.head 5 -  Class: CITFCBase
.head 4 -  Class Variables
.head 4 +  Instance Variables
.head 5 -  ! private
.head 5 -  Number: __pMemory
.head 5 -  Number: __nSize
.head 5 -  Boolean: __bFreeOnDestruct
.head 4 +  Functions
.head 5 -  ! public
.head 5 +  Function: Construct
.head 6 -  Description: Allocates internal memory and initializes the instance
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE = 0k
.head 6 +  Parameters
.head 7 +  Number: p_nSize
.head 8 -  ! Number of bytes to allocate
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! if called twice, free previously allocated memory first
.head 7 +  If __pMemory
.head 8 -  Call Destruct()
.head 7 -  Set __pMemory = __CStructAllocFarMem( p_nSize )
.head 7 +  If __pMemory
.head 8 -  Set __nSize = p_nSize
.head 8 -  Call SetMemory( __pMemory, __nSize, 0 )
.head 7 -  Set __bFreeOnDestruct = TRUE
.head 7 -  ! memory pointer != 0 indicates successful allocation
.head 7 -  Return ( __pMemory > 0 )
.head 5 +  Function: Destruct
.head 6 -  Description: Frees the internal memory
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE = Ok
.head 6 -  Parameters
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! check if any memory was allocated
.head 7 +  If Not __pMemory
.head 8 -  Return CITFCMemory.SetLastError( ITE_NoAllocatedMemory, ITC_ERRCLASS_ITFC )
.head 7 -  ! free memory and clear variables
.head 7 +  If __bFreeOnDestruct
.head 8 -  Call __CStructFreeFarMem( __pMemory )
.head 7 -  Set __pMemory = 0
.head 7 -  Set __nSize = 0
.head 7 -  ! return result
.head 7 -  Return ITE_Ok
.head 5 +  Function: ConstructFromMem
.head 6 -  Description: Attaches a memory block to the object.
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE = Ok
.head 6 +  Parameters
.head 7 +  Number: p_pMemory
.head 8 -  ! A pointer to a memory block
.head 7 +  Number: p_nSize
.head 8 -  ! Size of the memory block
.head 7 -  Boolean: p_bFreeOnDestruct
.head 7 -  ! TRUE: memory is freed in destructor
FALSE: memory is never freed in this class
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! if called twice, free previously allocated memory first
.head 7 +  If __pMemory
.head 8 -  Call Destruct()
.head 7 -  ! simply set the variables to point to the memory block
.head 7 -  Set __pMemory = p_pMemory
.head 7 -  Set __nSize = p_nSize
.head 7 -  Set __bFreeOnDestruct = p_bFreeOnDestruct
.head 7 -  ! result is always ITE_Ok
.head 7 -  Return ITE_Ok
.head 5 +  Function: ConstructFromString
.head 6 -  Description: Attaches a memory block from a string.
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE = Ok
.head 6 +  Parameters
.head 7 +  String: p_sBuffer
.head 8 -  ! A string buffer where the internal pointer will refer to
.head 7 -  Boolean: p_bFreeOnDestruct
.head 7 -  ! TRUE: memory is freed in destructor
FALSE: memory is never freed in this class
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! if called twice, free previously allocated memory first
.head 7 +  If __pMemory
.head 8 -  Call Destruct()
.head 7 -  Set __pMemory = SWinStringGetBuffer( p_sBuffer, __nSize )
.head 7 -  Set __bFreeOnDestruct = p_bFreeOnDestruct
.head 7 -  ! return TRUE, if a pointer could be retrieved
.head 7 -  Return ( __pMemory > 0 )
.head 5 +  Function: GetSize
.head 6 -  Description: Returns the size of the internal buffer
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! returns the size of the internal buffer
.head 6 -  Parameters
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  Return __nSize
.head 5 +  Function: GetAddress
.head 6 -  Description: Returns the internal pointer
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! Internal pointer
.head 6 -  Parameters
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  Return __pMemory
.head 5 +  Function: GetNumber
.head 6 -  Description: Reads an numeric value from the buffer
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! Error number (0=Ok)
.head 6 +  Parameters
.head 7 +  Receive Number: r_nValue
.head 8 -  ! the value to return from the buffer
.head 7 +  Number: p_nPosition
.head 8 -  ! position in the buffer from where to read the value
.head 7 +  Number: p_nType
.head 8 -  ! data type
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! the type includes the information about the size in bytes
.head 7 +  If not __CheckPosition( p_nPosition, (p_nType & 0x00ff) )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 -  ! get the data depending on the type
.head 7 +  Select Case p_nType
.head 8 +  Case ITC_TYPE_BYTE
.head 9 -  Set r_nValue = __CStructGetByte( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_WORD
.head 9 -  Set r_nValue = __CStructGetWord( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_LONG
.head 9 -  Set r_nValue = __CStructGetLong( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_FLOAT
.head 9 -  Set r_nValue = __CStructGetFloat( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_DOUBLE
.head 9 -  Set r_nValue = __CStructGetDouble( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_BFLOAT
.head 9 -  Set r_nValue = __CStructGetBFloat( __pMemory, p_nPosition )
.head 9 -  Break
.head 8 +  Default
.head 9 -  ! an illegal type has been passed
.head 9 -  Set r_nValue = 0
.head 9 -  Return __Error( ITE_InvalidParam )
.head 7 -  Return __Error( ITE_Ok )
.head 5 +  Function: GetString
.head 6 -  Description: Reads a string value from the buffer
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! ITE_Ok or ITE_Error
.head 6 +  Parameters
.head 7 +  Receive String: r_sValue
.head 8 -  ! the value to read from the buffer
.head 7 +  Number: p_nPosition
.head 8 -  ! position in the buffer from where to read the value
.head 7 +  Number: p_nSizeInBytes
.head 8 -  ! max. bytes to read
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! make sure we don't read beyond the end of the memory block
.head 7 +  If Not __CheckPosition( p_nPosition, p_nSizeInBytes )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 -  ! getthe data
.head 7 +  If Not __CStructGetString( __pMemory, p_nPosition, p_nSizeInBytes, r_sValue )
.head 8 -  Return __Error( ITE_CStructError )
.head 7 -  Return __Error( ITE_Ok )
.head 5 +  Function: CopyFromMem
.head 6 -  Description: Copies a memory block into the buffer.
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! Error number (0=Ok)
.head 6 +  Parameters
.head 7 +  Number: p_pSourceMem
.head 8 -  ! source memory address
.head 7 +  Number: p_nSourcePos
.head 8 -  ! position in the source buffer from where to write the value
.head 7 +  Number: p_nDestPos
.head 8 -  ! position in the internal buffer where to write the value to
.head 7 +  Number: p_nSourceSize
.head 8 -  ! data size
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! make sure we don't read beyond the end of the memory block
.head 7 +  If Not __CheckPosition( p_nDestPos, p_nSourceSize )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 -  ! copy it...
.head 7 +  If Not __CStructCopyBuffer( __pMemory, p_nDestPos, p_pSourceMem, p_nSourcePos, p_nSourceSize )
.head 8 -  Return __Error( ITE_CStructError )
.head 7 -  Return __Error( ITE_Ok )
.head 5 +  Function: PutNumber
.head 6 -  Description: Writes an numeric value to the buffer
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! Error number (0=Ok)
.head 6 +  Parameters
.head 7 +  Number: p_nValue
.head 8 -  ! the value to put into the buffer
.head 7 +  Number: p_nPosition
.head 8 -  ! position in the buffer from where to write the value
.head 7 +  Number: p_nType
.head 8 -  ! data type (ITC_TYPE constants)
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! make sure we don't write beyond the end of the buffer.
The type also includes the number of bytes to write
.head 7 +  If Not __CheckPosition( p_nPosition, (p_nType&0x00ff) )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 -  ! write the data depending on the type
.head 7 +  Select Case p_nType
.head 8 +  Case ITC_TYPE_BYTE
.head 9 +  If not __CStructPutByte( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_WORD
.head 9 +  If not __CStructPutWord( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_LONG
.head 9 +  If not __CStructPutLong( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_FLOAT
.head 9 +  If not __CStructPutFloat( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_DOUBLE
.head 9 +  If not __CStructPutDouble( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Case ITC_TYPE_BFLOAT
.head 9 +  If not __CStructPutBFloat( __pMemory, p_nPosition, p_nValue )
.head 10 -  Return __Error( ITE_CStructError )
.head 9 -  Break
.head 8 +  Default
.head 9 -  ! Oops! Invalid type has been passed
.head 9 -  Return __Error( ITE_InvalidParam )
.head 7 -  Return __Error( ITE_Ok )
.head 5 +  Function: PutString
.head 6 -  Description: Writes a string value to the buffer.
.head 6 +  Returns
.head 7 +  Number:
.head 8 -  ! Error number (0=Ok)
.head 6 +  Parameters
.head 7 +  String: p_sValue
.head 8 -  ! the value to put into the buffer
.head 7 +  Number: p_nPosition
.head 8 -  ! position in the buffer from where to write the value
.head 7 +  Number: p_nSizeInBytes
.head 8 -  ! bytes to write. If you pass -1, SalStrLength() is used to determine the size
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! make sure we don't write beyond the end of the buffer.
The type also includes the number of bytes to write
.head 7 +  If Not __CheckPosition( p_nPosition, p_nSizeInBytes )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 +  If p_nSizeInBytes < 0
.head 8 -  Set p_nSizeInBytes = SalStrLength( p_sValue )
.head 7 -  ! write the data
.head 7 +  If Not __CStructPutString( __pMemory, p_nPosition, p_nSizeInBytes, p_sValue )
.head 8 -  Return __Error( ITE_CStructError )
.head 7 -  Return __Error( ITE_Ok )
.head 5 +  Function: SetMemory
.head 6 -  Description:
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE=Ok
.head 6 +  Parameters
.head 7 +  Number: p_nStartPosition
.head 8 -  ! where to start filling memory
.head 7 +  Number: p_nCount
.head 8 -  ! number of bytes to fill.
Pass -1 here to fill entire memory block, the first parameter is ignored then
.head 7 +  Number: p_nCharacter
.head 8 -  ! character to fill the merory with
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 +  If p_nCount < 0
.head 8 -  Set p_nCount = __nSize
.head 8 -  Set p_nStartPosition = 0
.head 7 -  ! make sure we don't write beyond the end of the buffer
.head 7 +  If Not __CheckPosition( p_nStartPosition, p_nCount )
.head 8 -  Return __Error( ITE_ParamOutOfRange )
.head 7 -  ! fill memory
.head 7 -  Call memset( __pMemory, p_nCharacter, __nSize )
.head 7 -  Return ..CITFCMemory_Error( ITE_Ok, ITC_ERRCLASS_ITFC )
.head 5 -  ! private
.head 5 +  Function: __Error
.head 6 -  Description: Sets the class errors.
.head 6 +  Returns
.head 7 -  Boolean:
.head 6 +  Parameters
.head 7 -  Number: p_nErrorCode
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  Return ..CITFCMemory_Error( p_nErrorCode, ITC_ERRCLASS_ITFC )
.head 5 +  Function: __CheckPosition
.head 6 -  Description: This function checks position and size of bytes to
read from or write to the internal buffer. If reading
or writing go beyond the size of the buffer, this
function returns FALSE
.head 6 +  Returns
.head 7 +  Boolean:
.head 8 -  ! TRUE: position and size parameters fit into buffer
.head 6 +  Parameters
.head 7 +  Number: p_nPosition
.head 8 -  ! Position from where to start reading/writing (zero based)
.head 7 +  Number: p_nSize
.head 8 -  ! Number of bytes to read or write
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  ! check if parameters are valid
.head 7 +  If (p_nPosition < 0) Or (p_nSize < 0)
.head 8 -  Return __Error( ITE_InvalidParam )
.head 7 -  ! check if parameters point beyond end of buffer
.head 7 +  If (p_nPosition + p_nSize) > __nSize
.head 8 -  Return __Error( ITE_InvalidBufferPos )
.head 7 -  Return ITE_Ok
.head 5 -  ! virtual
.head 5 +  Function: CITFCMemory_Error
.head 6 -  Description: Sets the class error code. This function is overwritable in
derived classes.
.head 6 +  Returns
.head 7 -  Boolean:
.head 6 +  Parameters
.head 7 -  Number: p_nErrorCode
.head 7 -  Number: p_nErrorClass
.head 6 -  Static Variables
.head 6 -  Local variables
.head 6 +  Actions
.head 7 -  Return SetLastError( p_nErrorCode, p_nErrorClass )
.head 2 +  Default Classes
.head 3 -  MDI Window: cBaseMDI
.head 3 -  Form Window:
.head 3 -  Dialog Box:
.head 3 -  Table Window:
.head 3 -  Quest Window:
.head 3 -  Data Field:
.head 3 -  Spin Field:
.head 3 -  Multiline Field:
.head 3 -  Pushbutton:
.head 3 -  Radio Button:
.head 3 -  Option Button:
.head 3 -  Check Box:
.head 3 -  Child Table:
.head 3 -  Quest Child Window: cQuickDatabase
.head 3 -  List Box:
.head 3 -  Combo Box:
.head 3 -  Picture:
.head 3 -  Vertical Scroll Bar:
.head 3 -  Horizontal Scroll Bar:
.head 3 -  Column:
.head 3 -  Background Text:
.head 3 -  Group Box:
.head 3 -  Line:
.head 3 -  Frame:
.head 3 -  Custom Control:
.head 3 -  ActiveX:
.head 2 -  Application Actions
