// *****************************************************************
//
//  NFYINTF.C -	DesignHook dll for BuildTool derived 
//				from a GUPTA sample
//  christian@cschubert.net
//  12/04/2002
//
// *****************************************************************

#include "nfyintf.h"
#include "cdkapi.h"

#define WM_COMMAND_BUILD 0xFFF0			// our build identifier
#define WM_TD_COMMAND_BUILD 0x8091		// TD's build menu identifier
#define WM_COMMAND_SAVE 0xFFF1			// our save identifier
#define WM_TD_COMMAND_SAVE 0xE103		// TD's save menu identifier
#define WM_COMMAND_INFOCOLLECTOR 0xFFF2	// our info collector identifier
#define WM_COMMAND_REPORT 0xFFF3	// our build report identifier
#define WM_COMMAND_SETVERSION 0xFFF4	// our set version identifier

#define BF_INFOCOLLECTOR 32				// info collector flag

#ifdef CTD11
#define EXECUTABLE "BTool11.exe"
#endif
#ifdef CTD15
#define EXECUTABLE "BTool15.exe"
#endif
#ifdef CTD20
#define EXECUTABLE "BTool20.exe"
#endif
#ifdef CTD21
#define EXECUTABLE "BTool21.exe"
#endif
#ifdef CTD30
#define EXECUTABLE "BTool30.exe"
#endif
#ifdef CTD31
#define EXECUTABLE "BTool31.exe"
#endif
#ifdef CTD40
#define EXECUTABLE "BTool40.exe"
#endif

#define COLLECTOR_MENU "Build text co&llector..."	// menu string for info collector menu
#define REPORT_MENU "Buil&d report..."	// menu string for print menu

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HMODULE hModule;
extern "C" HOUTLINE SalOutlineCurrent ( void );

HOUTLINE hOutline = NULL;
UINT Timer;

//IMPLEMENT_DYNAMIC ( CGMyNotificationInterface, CGMyNotificationInterface );

extern "C" void CenturaTool( HOUTLINE hOutline, LPCSTR sParam )
{
  UNREFERENCED_PARAMETER(hOutline);
  UNREFERENCED_PARAMETER(sParam);

  // Self reference so we won't be unloaded
  hModule = ::LoadLibrary(AfxGetApp()->m_pszExeName);
  CDKStartNotifications();
}

// Called when Centura loads the DLL from a DesignHookDLL entry in the registry.
/*void CGMyNotificationInterface::OnSetHook()
{
};*/

// Get value of __BUILDFLAGS from the current outline
int GetInfoCollectorFlag ( HOUTLINE hOutline )
{
	CGApplication App ( hOutline );
	CGItem BuildFlagsItem;
#ifdef CTD11
	CBString Text;
#endif
#ifdef CTD15
	CBString Text;
#endif
#ifdef CTD20
	CGString Text;
#endif
#ifdef CTD21
	CGString Text;
#endif
#ifdef CTD30
	CGString Text;
#endif
#ifdef CTD31
	CGString Text;
#endif
#ifdef CTD40
	CGString Text;
#endif

	LPTSTR pText;
	int nHelp;

	// Get OutlineItem of buildflags if neccessary
	if ( !App.GetChildObjectByName ( "__BUILDFLAGS", BuildFlagsItem, kIT_SystemConstants ) )
		return 0;

	// get constant text
	Text = BuildFlagsItem.GetText();
	if ( Text.GetLength != 0 )
	{
		pText = Text.GetBuffer ( 10 );
		strtok ( pText, "=" );
		pText = strtok ( NULL, "=" );
		nHelp = 0;
		nHelp = ( ( atoi ( pText ) ) & BF_INFOCOLLECTOR ) != 0;
		Text.ReleaseBuffer ( );
		return nHelp;
	}
	else
		return 0;
}

void SetWindowProcedure ( )
{
	if ( ! hOutline )
	{
		HOUTLINE hOutline = SalOutlineCurrent ( );
		CGApplication App ( hOutline );
		HWND hWndApp = App.GetWindowOfApp ( );
		WNDPROC pWndProcOrg = (WNDPROC) GetWindowLong ( hWndApp, GWL_WNDPROC );
		if ( pWndProcOrg != (WNDPROC)GetProp ( hWndApp, "BuildTool" ) )
		{
			SetProp ( hWndApp, "BuildTool", (HANDLE)pWndProcOrg );
			SetWindowLong ( hWndApp, GWL_WNDPROC, (long)NewWindowProc );
		}
	}
}

void SetFileVersion ( LPSTR sVersion )
{
	INT nTargetType;
	HSTRING sTargetName;
	HSTRING sDLLName;
	HSTRING sIconName;
	HSTRING sHelpFileName;
	HSTRING sGUID;
	BOOL bPlayback;
	INT nCacheSize;
	BOOL bResEdit;
	BOOL bMultiUse;
	BOOL bUseObjCompiler;
	INT nVerMajor;
	INT nVerMinor;
	INT nOptimizationType;
	INT nThreadingType;
	INT nThreadingModel;
	HARRAY haVersionStringName;
	HARRAY haVersionStringValue;
	long nCount, nMaxCount;
	HSTRING hVersionString;
	LPSTR sVersionString;
	long nLength;
	HOUTLINE hOutline = SalOutlineCurrent ( );

	if ( !CDKRetrieveBuildSettings ( hOutline, &nTargetType, &sTargetName, &sDLLName, 
		&sIconName, &sHelpFileName, &sGUID, &bPlayback, &nCacheSize, &bResEdit, &bMultiUse,
		&bUseObjCompiler, &nVerMajor, &nVerMinor, &nOptimizationType, &nThreadingType, &nThreadingModel,
		(HARRAY)&haVersionStringName, (HARRAY)&haVersionStringValue ) )
		return;

	SalArrayGetUpperBound ( haVersionStringName, 1, &nMaxCount );

	sVersionString = SWinHStringLock ( sTargetName, &nLength );

	for ( nCount = 0; nCount <= nMaxCount; nCount++ )
	{
		SWinMDArrayGetHString ( haVersionStringName, &hVersionString, nCount );
		sVersionString = SWinHStringLock ( hVersionString, &nLength );
		if ( !strcmp ( sVersionString, "FileVersion" ) )
		{
			SWinMDArrayGetHString ( haVersionStringValue, &hVersionString, nCount );
			SWinInitLPHSTRINGParam ( &hVersionString, sizeof ( "FileVersion" ) + 1 );
			sVersionString = SWinHStringLock ( hVersionString, &nLength );
			strncpy ( sVersionString, sVersion, nLength );

			if ( !CDKUpdateBuildSettings ( hOutline, nTargetType, sTargetName, sDLLName, 
				sIconName, sHelpFileName, sGUID, bPlayback, nCacheSize, bResEdit, bMultiUse,
				bUseObjCompiler, nVerMajor, nVerMinor, nOptimizationType, nThreadingType, nThreadingModel,
				haVersionStringName, haVersionStringValue ) )
				return;

			break;
		}
	}


}

// New window procedure for the builder window
LRESULT CALLBACK NewWindowProc(
  HWND hwnd,      // handle to window
  UINT uMsg,      // message identifier
  WPARAM wParam,  // first message parameter
  LPARAM lParam   // second message parameter
)
{
	char sChar[255];
	char sChar2[10];
	static int nCount = 0;
	long nResult;
	HOUTLINE hOutline = SalOutlineCurrent ( );
	int nCommand = 0;
	LRESULT nRet;
	MENUITEMINFO mii;
	static BOOL bMenuChanged;

	if ( uMsg == WM_TIMER )
	{
		if ( wParam == Timer )
		{
			KillTimer ( NULL, Timer );
			SetWindowProcedure ( );
			return 0;
		}
	}

	// Get address of previous window procedure
	static WNDPROC pWndProcOrg = (WNDPROC) GetProp ( hwnd, "BuildTool" );

	if ( pWndProcOrg )
	{
		switch ( uMsg )
		{
		case WM_COMMAND:
			{
				// intercept build and save commands
				if ( LOWORD ( wParam ) == WM_TD_COMMAND_BUILD )
				{
					// build the command line string
					// 1. dialog name
					strcpy ( sChar, "dlgAskBuildRequired " );
					// 2. outline handle
					ltoa ( (long)hOutline, sChar2, 10 );
					strcat ( sChar, sChar2 );
					strcat ( sChar, " 0 " );
					// 3. window handle of builder window
					ltoa ( (long)hwnd, sChar2, 10 );
					strcat ( sChar, sChar2 );
#ifdef CTD31
					strcat ( sChar, " -MTX" );
#endif
#ifdef CTD40
					strcat ( sChar, " -MTX" );
#endif
					// execute build tool
					nResult = (long)ShellExecute ( hwnd, "open", EXECUTABLE, sChar, "", SW_SHOW );
					if ( nResult < 32 )
						MessageBox ( hwnd, "Unable to execute BuildTool!", EXECUTABLE, MB_ICONINFORMATION );
					return 0;
				}
				if ( LOWORD ( wParam ) == WM_TD_COMMAND_SAVE )
				{
					// get window title of main window
					SendMessage ( hwnd, WM_GETTEXT, sizeof ( sChar ), (LPARAM)&sChar );
					_strupr ( sChar );
					// check if info collector should be shown, flag and APL
					if ( !( GetKeyState ( VK_SHIFT ) & 0x8000 ) && GetInfoCollectorFlag ( hOutline ) && strstr ( sChar, ".APL") == NULL )
					{
						// build the command line string
						// 1. dialog name
						strcpy ( sChar, "dlgBuildInfo " );
						// 2. outline handle
						ltoa ( (long)hOutline, sChar2, 10 );
						strcat ( sChar, sChar2 );
						strcat ( sChar, " 0 " );
						// 3. window handle of builder window
						ltoa ( (long)hwnd, sChar2, 10 );
						strcat ( sChar, sChar2 );
						// 4. additional commands
						strcat ( sChar, " save" );

#ifdef CTD31
					strcat ( sChar, " -MTX" );
#endif
#ifdef CTD40
					strcat ( sChar, " -MTX" );
#endif

						// execute build tool
						nResult = (long)ShellExecute ( hwnd, "open", EXECUTABLE, sChar, "", SW_SHOW );
						if ( nResult < 32 )
							MessageBox ( hwnd, "Unable to execute BuildTool!", EXECUTABLE, MB_ICONINFORMATION );
						return 1;
					}
					else
					{
						// we are done, call the original window procedure
						nRet = CallWindowProc ( pWndProcOrg, hwnd, uMsg, wParam, lParam );
						return nRet;
					}
				}
				// user wants to see info collector 
				if ( LOWORD ( wParam ) == WM_COMMAND_INFOCOLLECTOR )
				{
						// build the command line string
						// 1. dialog name
						strcpy ( sChar, "dlgBuildInfo " );
						// 2. outline handle
						ltoa ( (long)hOutline, sChar2, 10 );
						strcat ( sChar, sChar2 );
						strcat ( sChar, " 0 " );
						// 3. window handle of builder window
						ltoa ( (long)hwnd, sChar2, 10 );
						strcat ( sChar, sChar2 );

#ifdef CTD31
					strcat ( sChar, " -MTX" );
#endif
#ifdef CTD40
					strcat ( sChar, " -MTX" );
#endif

						// execute build tool
						nResult = (long)ShellExecute ( hwnd, "open", EXECUTABLE, sChar, "", SW_SHOW );
						if ( nResult < 32 )
							MessageBox ( hwnd, "Unable to execute BuildTool!", EXECUTABLE, MB_ICONINFORMATION );
						return 1;
				}
				// user wants to print build report 
				if ( LOWORD ( wParam ) == WM_COMMAND_REPORT )
				{
						// build the command line string
						// 1. dialog name
						strcpy ( sChar, "dlgReport " );
						// 2. outline handle
						ltoa ( (long)hOutline, sChar2, 10 );
						strcat ( sChar, sChar2 );
						strcat ( sChar, " 0 " );
						// 3. window handle of builder window
						ltoa ( (long)hwnd, sChar2, 10 );
						strcat ( sChar, sChar2 );

#ifdef CTD31
					strcat ( sChar, " -MTX" );
#endif
#ifdef CTD40
					strcat ( sChar, " -MTX" );
#endif

						// execute build tool
						nResult = (long)ShellExecute ( hwnd, "open", EXECUTABLE, sChar, "", SW_SHOW );
						if ( nResult < 32 )
							MessageBox ( hwnd, "Unable to execute BuildTool!", EXECUTABLE, MB_ICONINFORMATION );
						return 1;
				}
				// user wants to set file version 
				if ( LOWORD ( wParam ) == WM_COMMAND_SETVERSION )
				{
						SetFileVersion ( (LPSTR)lParam );
						return 1;
				}


				// simulate build and save commands
				if ( LOWORD ( wParam ) == WM_COMMAND_BUILD )
				{
					wParam = WM_TD_COMMAND_BUILD;
				}
				if ( LOWORD ( wParam ) == WM_COMMAND_SAVE )
				{
					wParam = WM_TD_COMMAND_SAVE;
					}
			}
		
			// we are done, call the original window procedure
			nRet = CallWindowProc ( pWndProcOrg, hwnd, uMsg, wParam, lParam );
			return nRet;

		// change the builder menu
		case WM_INITMENUPOPUP:
			if ( !bMenuChanged && (HMENU)wParam == GetSubMenu ( GetMenu ( hwnd ), 3 ) )
			{
				memset ( &mii, sizeof ( mii ), 0 );
				mii.cbSize = sizeof ( mii );
				mii.fMask = MIIM_TYPE | MIIM_ID;
				mii.fType = MFT_STRING;
				mii.dwTypeData = COLLECTOR_MENU;
				mii.cch = strlen ( COLLECTOR_MENU ) + 1;
				mii.wID = WM_COMMAND_INFOCOLLECTOR;
#ifdef CTD15
				InsertMenuItem ( (HMENU)wParam, 8, TRUE, &mii );
				mii.fType = MFT_SEPARATOR;
				InsertMenuItem ( (HMENU)wParam, 8, TRUE, &mii );
#else
				InsertMenuItem ( (HMENU)wParam, 13, TRUE, &mii );
				mii.fType = MFT_SEPARATOR;
				InsertMenuItem ( (HMENU)wParam, 13, TRUE, &mii );
#endif

				mii.dwTypeData = REPORT_MENU;
				mii.cch = strlen ( REPORT_MENU ) + 1;
				mii.wID = WM_COMMAND_REPORT;
				mii.fType = MFT_STRING;

#ifdef CTD15
				InsertMenuItem ( (HMENU)wParam, 10, TRUE, &mii );
#else
				InsertMenuItem ( (HMENU)wParam, 15, TRUE, &mii );
#endif

				bMenuChanged = TRUE;
			}

		// nothing to do, call the original window procedure
		default:
			nRet = CallWindowProc ( pWndProcOrg, hwnd, uMsg, wParam, lParam );
			return nRet;
		}
	}
	nRet = DefWindowProc ( hwnd, uMsg, wParam, lParam );
	return nRet;
};


// The currently selected item may have changed
/*void CGMyNotificationInterface::OnContextChange(CGItem & Item)
{
	if ( ! hOutline )
	{
		HOUTLINE hOutline = SalOutlineCurrent ( );
		CGApplication App ( hOutline );
		HWND hWndApp = App.GetWindowOfApp ( );
		WNDPROC pWndProcOrg = (WNDPROC) GetWindowLong ( hWndApp, GWL_WNDPROC );
		if ( pWndProcOrg != (WNDPROC)GetProp ( hWndApp, "BuildTool" ) )
		{
			SetProp ( hWndApp, "BuildTool", (HANDLE)pWndProcOrg );
			SetWindowLong ( hWndApp, GWL_WNDPROC, (long)NewWindowProc );
		}
	}
};*/

// An attribute of the item has been changed
/*void CGMyNotificationInterface::OnEditAttribute(CGItem & Item)
{
};

// An item has been deleted
void CGMyNotificationInterface::OnEditDelete(HOUTLINE hOutline, HITEM hItem)
{
};

// An item has been inserted
void CGMyNotificationInterface::OnEditInsert(CGItem & Item)
{
};

// The contents of a list item has been changed
void CGMyNotificationInterface::OnEditList(CGItem & Item)
{
};

// An item has been pasted
void CGMyNotificationInterface::OnEditPaste(CGItem & Item)
{
};

// An item title has been changed
void CGMyNotificationInterface::OnEditTitle(CGItem & Item)
{
};

// The item type of the item has been changed
void CGMyNotificationInterface::OnEditType(CGItem & Item)
{
};

// A new application file has been read.
void CGMyNotificationInterface::OnFileRead(CGApplication & App)
{
};

// The current application file is about to be written
void CGMyNotificationInterface::OnFileBeforeWrite(CGApplication & App)
{
};

// The current application file has been written.
void CGMyNotificationInterface::OnFileWrite(CGApplication & App)
{
};

// Start refreshing included
void CGMyNotificationInterface::OnIncludeRefreshBegin(CGApplication & App)
{
};

// Refreshing included completed
void CGMyNotificationInterface::OnIncludeRefreshEnd(CGApplication & App)
{
};

// Enter design mode.  
void CGMyNotificationInterface::OnRunDesign(CGApplication & App)
{
};

// Enter user mode.  
void CGMyNotificationInterface::OnRunUser(CGApplication & App)
{
};

// The main window is being activated
void CGMyNotificationInterface::OnTaskActivate(CGApplication & App)
{
//	SetPopupHook ( );
};

// The main window is being deactivated
void CGMyNotificationInterface::OnTaskDeactivate(CGApplication & App)
{
};
*/
// Builder is being shutdown
/*void CGMyNotificationInterface::OnTaskShutdown()
{
//	ClearPopupHook ( );
  ::FreeLibrary(hModule);
};*/
/*
void CGMyNotificationInterface::OnUnknownNotification( int nGroup, int nEvent, HOUTLINE hOutline, HITEM hItem )
{
}*/
