//--------------------------------------------------------------
//
//		CALLBACK.DLL
//		Callback Emulator for Centura CTD
//
//		This module maps windows callback procedures to
//		CTD functions
//
//		Author:	Christian Schubert 
//		Email:	christian@cschubert.net
//		Last changed: 2002-03-07
//
//--------------------------------------------------------------

//-------- Includes -----------
#include <windows.h>
#include <stdarg.h>
#include "cbtype.h"
#include "centura.h"

#define BUFFERLENGTH 100

//-------- Globals ------------
char	sProcName1[BUFFERLENGTH] = "";
char	sProcName2[BUFFERLENGTH] = "";
char	sProcName3[BUFFERLENGTH] = "";
char	sCurrentContextValue[BUFFERLENGTH] = "";
BOOL	bGlobalReportErrors1;
BOOL	bGlobalReportErrors2;
BOOL	bGlobalReportErrors3;
HANDLE	hGlobalModule;


//-------- ExecuteParamString ------------
//
// Executes the SAL callback function by calling SalCompileAndEvaluate
//
//----------------------------------------
LRESULT ExecuteParamString ( BOOL bReportErrors, LPSTR sSalString )
{
	int nError, nErrorPos;

	// Dummy result vars
	NUMBER nResult;
	HSTRING sResult;
	DATETIME dResult;
	HWND hResult;
	long nLength, nRet;
	HSTRING sCurrentContext;
	LPSTR pContext;

	sCurrentContext = SalContextCurrent();
	pContext = SWinHStringLock ( sCurrentContext, &nLength );
	memset ( sCurrentContextValue, '\0', sizeof ( sCurrentContextValue ) );
	memcpy ( sCurrentContextValue, pContext, min(nLength, BUFFERLENGTH) );

	if ( 1 == SalCompileAndEvaluate( sSalString, &nError, &nErrorPos, &nResult, &sResult, &dResult, &hResult, bReportErrors, sCurrentContextValue) )
		if ( SWinCvtNumberToLong ( &nResult, &nRet ) )
		{
			SWinHStringUnlock ( sCurrentContext );
			return nRet;
		}


	SWinHStringUnlock ( sCurrentContext );
	return 0;

}

//-------- TransferParams ------------
//
// Builds a string in SAL syntax and inserts 
// the parameter values as numeric constants.
//
//------------------------------------
LRESULT TransferParams ( LPSTR sProcName, BOOL bReportErrors, WORD nNumParams, ... )
{
	va_list vl;
	WORD nCount;
	char sParamNumber[12];
	char sSalString[254];

	strcpy ( sSalString, sProcName );

	strcat ( sSalString, "(" );

	// initialize dynamic param list
	va_start( vl, nNumParams );

	for ( nCount=0; nCount<nNumParams; nCount++ )
	{
		// append comma if not first param
		if ( nCount )
			strcat ( sSalString, "," );
		// convert param to decimal string
		 _itoa ( va_arg( vl, int ), sParamNumber, 10 );
		 // append param
		 strcat ( sSalString, sParamNumber );
	}
		 
	strcat ( sSalString, ")" );

	// end dynamic param processing
	va_end( vl );

	// execute the SAL command
	return ExecuteParamString ( bReportErrors, sSalString );
}


// The following lines contain separate functions for any number of parameters needed

//----1 parameter--------------------------------

LRESULT CALLBACK CallbackProc1_1( DWORD dwParam1 )
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 1, dwParam1 );
}


//----2 parameters--------------------------------

LRESULT CALLBACK CallbackProc2_1( DWORD dwParam1, DWORD dwParam2 )
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 2, dwParam1, dwParam2 );
}


//----3 parameters--------------------------------
LRESULT CALLBACK CallbackProc3_1( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3 )
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 3, dwParam1, dwParam2, dwParam3 );
}


//----4 parameters--------------------------------
LRESULT CALLBACK CallbackProc4_1( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4)
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 4, dwParam1, dwParam2, dwParam3, dwParam4 );
}


//----5 parameters--------------------------------
LRESULT CALLBACK CallbackProc5_1( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5)
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 5, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5 );
}


//----6 parameters--------------------------------
LRESULT CALLBACK CallbackProc6_1( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5, DWORD dwParam6)
{
	return TransferParams ( sProcName1, bGlobalReportErrors1, 6, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5, dwParam6 );
}
//----1 parameter--------------------------------

LRESULT CALLBACK CallbackProc1_2( DWORD dwParam1 )
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 1, dwParam1 );
}


//----2 parameters--------------------------------

LRESULT CALLBACK CallbackProc2_2( DWORD dwParam1, DWORD dwParam2 )
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 2, dwParam1, dwParam2 );
}


//----3 parameters--------------------------------
LRESULT CALLBACK CallbackProc3_2( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3 )
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 3, dwParam1, dwParam2, dwParam3 );
}


//----4 parameters--------------------------------
LRESULT CALLBACK CallbackProc4_2( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4)
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 4, dwParam1, dwParam2, dwParam3, dwParam4 );
}


//----5 parameters--------------------------------
LRESULT CALLBACK CallbackProc5_2( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5)
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 5, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5 );
}


//----6 parameters--------------------------------
LRESULT CALLBACK CallbackProc6_2( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5, DWORD dwParam6)
{
	return TransferParams ( sProcName2, bGlobalReportErrors2, 6, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5, dwParam6 );
}
//----1 parameter--------------------------------

LRESULT CALLBACK CallbackProc1_3( DWORD dwParam1 )
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 1, dwParam1 );
}


//----2 parameters--------------------------------

LRESULT CALLBACK CallbackProc2_3( DWORD dwParam1, DWORD dwParam2 )
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 2, dwParam1, dwParam2 );
}


//----3 parameters--------------------------------
LRESULT CALLBACK CallbackProc3_3( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3 )
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 3, dwParam1, dwParam2, dwParam3 );
}


//----4 parameters--------------------------------
LRESULT CALLBACK CallbackProc4_3( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4)
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 4, dwParam1, dwParam2, dwParam3, dwParam4 );
}


//----5 parameters--------------------------------
LRESULT CALLBACK CallbackProc5_3( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5)
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 5, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5 );
}


//----6 parameters--------------------------------
LRESULT CALLBACK CallbackProc6_3( DWORD dwParam1, DWORD dwParam2, DWORD dwParam3, DWORD dwParam4, DWORD dwParam5, DWORD dwParam6)
{
	return TransferParams ( sProcName3, bGlobalReportErrors3, 6, dwParam1, dwParam2, dwParam3, dwParam4, dwParam5, dwParam6 );
}


//-----SetCallback------------------------
//
//  Set the name of the SAL callback handler
//  and return the address of the callback 
//  procedure according to the number of 
//  parameters
//
//----------------------------------------

void SetCallback ( LPSTR sProc, int nNumParams, BOOL bReportErrors, LPVOID* pProc, LPHANDLE pModule )
{
	memset ( sProcName1, '\0', sizeof ( sProcName1 ) );
	strncpy ( sProcName1, sProc, BUFFERLENGTH - 1 );

	bGlobalReportErrors1 = bReportErrors;

	switch ( nNumParams )
	{
		case 1:
		{
			*pProc = CallbackProc1_1;
			break;
		}
		case 2:
		{
			*pProc = CallbackProc2_1;
			break;
		}
		case 3:
		{
			*pProc = CallbackProc3_1;
			break;
		}
		case 4:
		{
			*pProc = CallbackProc4_1;
			break;
		}
		case 5:
		{
			*pProc = CallbackProc5_1;
			break;
		}
		case 6:
		{
			*pProc = CallbackProc6_1;
			break;
		}
		default:
		{
			*pProc = NULL;
		}
	}

	*pModule = hGlobalModule;
}
void SetCallback2 ( LPSTR sProc, int nNumParams, BOOL bReportErrors, LPVOID* pProc, LPHANDLE pModule )
{
	memset ( sProcName2, '\0', sizeof ( sProcName2 ) );
	strncpy ( sProcName2, sProc, BUFFERLENGTH - 1 );

	bGlobalReportErrors2 = bReportErrors;

	switch ( nNumParams )
	{
		case 1:
		{
			*pProc = CallbackProc1_2;
			break;
		}
		case 2:
		{
			*pProc = CallbackProc2_2;
			break;
		}
		case 3:
		{
			*pProc = CallbackProc3_2;
			break;
		}
		case 4:
		{
			*pProc = CallbackProc4_2;
			break;
		}
		case 5:
		{
			*pProc = CallbackProc5_2;
			break;
		}
		case 6:
		{
			*pProc = CallbackProc6_2;
			break;
		}
		default:
		{
			*pProc = NULL;
		}
	}

	*pModule = hGlobalModule;
}
void SetCallback3 ( LPSTR sProc, int nNumParams, BOOL bReportErrors, LPVOID* pProc, LPHANDLE pModule )
{
	memset ( sProcName3, '\0', sizeof ( sProcName3 ) );
	strncpy ( sProcName3, sProc, BUFFERLENGTH - 1 );

	bGlobalReportErrors3 = bReportErrors;

	switch ( nNumParams )
	{
		case 1:
		{
			*pProc = CallbackProc1_3;
			break;
		}
		case 2:
		{
			*pProc = CallbackProc2_3;
			break;
		}
		case 3:
		{
			*pProc = CallbackProc3_3;
			break;
		}
		case 4:
		{
			*pProc = CallbackProc4_3;
			break;
		}
		case 5:
		{
			*pProc = CallbackProc5_3;
			break;
		}
		case 6:
		{
			*pProc = CallbackProc6_3;
			break;
		}
		default:
		{
			*pProc = NULL;
		}
	}

	*pModule = hGlobalModule;
}


//-----DllMain------------------------
BOOL APIENTRY DllMain( HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved )
{
	hGlobalModule = hModule;

    return 1;
}

                    
